﻿#check for the existence of the Outputs folder
function CheckAndCreateFolder($rootFolder, [switch]$Outputs)
{
    $location = $rootFolder

    #setting up location 
    if($Outputs -eq $true)
    {
        $location += "\Outputs"
    }
   
    #if the folder doesn't exist it will be created
    if(-not (Test-Path $location))
    { mkdir $location -Force:$true -Confirm:$false | Out-Null }

    return $location
}

#root folder for the schema sync process
$rootFolder = "SchemaSync"

#output files location 
$outsLoc = CheckAndCreateFolder $rootFolder -Outputs

#Output log file path
$logPath = "$outsLoc\SchemaOutput_$stamp.txt"

#ApexSQL Diff location, date stamp variable is defined, along with tool’s parameters 
$diffLoc   = "C:\Program Files\ApexSQL\ApexSQL Diff\ApexSQLDiff.com"
$stamp = (Get-Date -Format "MMddyyyy_HHMMss") 
$Params = "/pr:""MyProject.axds"" /out:""$logPath"" /sync /v /f /rece"

 #initiate the comparison and commit process
(Invoke-Expression ("& `"" + $diffLoc +"`" " +$Params))
$returnCode = $LASTEXITCODE

$message = ""

#schema changes are detected
if($returnCode -eq 0)
{
    $message = "`r`n $returnCode - Schema changes were successfully synchronized"

}
else
{
    #there are no schema changes
    if($returnCode -eq 102)
    {
        $message = "`r`n $returnCode - There are no schema changes. Job aborted"
    }
    #an error is encountered
    else
    {
        $message = "`r`n $returnCode - An error is encountered"
	
        #output file is opened when an error is encountered
        Invoke-Item -Path $logPath
    }

}

$message >> $logPath